/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.util.BitSet;

class TypeAdapters$2
extends TypeAdapter<BitSet> {
    TypeAdapters$2() {
    }

    @Override
    public BitSet read(JsonReader jsonReader) {
        BitSet bitSet = new BitSet();
        jsonReader.beginArray();
        int n = 0;
        JsonToken jsonToken = jsonReader.peek();
        while (jsonToken != JsonToken.END_ARRAY) {
            boolean bl;
            switch (jsonToken) {
                case NUMBER: 
                case STRING: {
                    int n2 = jsonReader.nextInt();
                    if (n2 == 0) {
                        bl = false;
                        break;
                    }
                    if (n2 == 1) {
                        bl = true;
                        break;
                    }
                    throw new JsonSyntaxException("Invalid bitset value " + n2 + ", expected 0 or 1; at path " + jsonReader.getPreviousPath());
                }
                case BOOLEAN: {
                    bl = jsonReader.nextBoolean();
                    break;
                }
                default: {
                    throw new JsonSyntaxException("Invalid bitset value type: " + (Object)((Object)jsonToken) + "; at path " + jsonReader.getPath());
                }
            }
            if (bl) {
                bitSet.set(n);
            }
            ++n;
            jsonToken = jsonReader.peek();
        }
        jsonReader.endArray();
        return bitSet;
    }

    @Override
    public void write(JsonWriter jsonWriter, BitSet bitSet) {
        jsonWriter.beginArray();
        int n = bitSet.length();
        for (int i = 0; i < n; ++i) {
            int n2 = bitSet.get(i) ? 1 : 0;
            jsonWriter.value(n2);
        }
        jsonWriter.endArray();
    }
}

