/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform;

import com.sun.jna.platform.win32.FlagEnum;
import java.util.HashSet;
import java.util.Set;

public class EnumUtils {
    public static final int UNINITIALIZED = -1;

    public static <E extends Enum<E>> int toInteger(E e) {
        Enum[] enumArray = (Enum[])e.getClass().getEnumConstants();
        for (int i = 0; i < enumArray.length; ++i) {
            if (enumArray[i] != e) continue;
            return i;
        }
        throw new IllegalArgumentException();
    }

    public static <E extends Enum<E>> E fromInteger(int n, Class<E> clazz) {
        if (n == -1) {
            return null;
        }
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        return (E)enumArray[n];
    }

    public static <T extends FlagEnum> Set<T> setFromInteger(int n, Class<T> clazz) {
        FlagEnum[] flagEnumArray = (FlagEnum[])clazz.getEnumConstants();
        HashSet<FlagEnum> hashSet = new HashSet<FlagEnum>();
        for (FlagEnum flagEnum : flagEnumArray) {
            if ((n & flagEnum.getFlag()) == 0) continue;
            hashSet.add(flagEnum);
        }
        return hashSet;
    }

    public static <T extends FlagEnum> int setToInteger(Set<T> set) {
        int n = 0;
        for (FlagEnum flagEnum : set) {
            n |= flagEnum.getFlag();
        }
        return n;
    }
}

